function [] = ContrastAna_function(SimplyNameT,FullNameT)
%UNTITLED13 此处提供此函数的摘要
%   此处提供详细说明

for i_sub=1:length(SimplyNameT)

SubjectName=SimplyNameT{i_sub};
FullName_temp=FullNameT{i_sub};

IniPath='E:\DATA_SEEG\行为结果\';
% cd('E:\Data\论文用结果\肖军\');

workpath=['E:\DATA_SEEG\行为结果\',SubjectName,...
    '_VisualAwareData\'];
outputpath=[IniPath,'Result\',SubjectName,'_beh\'];
mkdir(outputpath)
DataFilePath=[workpath,'\*_VisualAware_*.mat'];
DataList =dir(DataFilePath);
% cd(strcat('E:\Data\论文用结果\肖军\处理数据集\',SubjectName,'_VisualAwareData'))
ContraSession=[];

for j=1:length(DataList)
SessionName=DataList(j).name;
load([workpath,SessionName]);
Result=[];
FtrialNum=1;
max_itrial=SessionSet.max_itrial;
for i_trial=1:max_itrial
    trial_complete(i_trial)=Trial(i_trial).trial_complete;
    if trial_complete(i_trial)==1
    Result(1,FtrialNum)=Trial(i_trial).Sti.Contrast; %  StiContrast
    Result(2,FtrialNum)=Trial(i_trial).AwareType1U2A;
    FtrialNum=FtrialNum+1;
    end
end

ContraSession{1,j}=Result;
ContraSession{2,j}=Picture.StiContrast;
ContraSession{3,j}=Picture.AwarePercent;
end
cd(outputpath)
% save('ContrastSession',ContraSession,'.mat')

ContrTotal=[];
ucT=[];
acT=[];
pt=[];
for j=1:length(ContraSession)
    contradrtemp=find(ContraSession{3,j}<=0.75 & ContraSession{3,j}>=0.25);
%     contradrtemp=find(ContraSession{3,j}>=0.75);
    contratemp=ContraSession{2,j}( contradrtemp);
    contratemp(contratemp==0)=[];
    ntcontratemp=ContraSession{1,j}(:,ismember(ContraSession{1,j}(1,:),contratemp'));
    uad=find(ntcontratemp(2,:)==1); %索引地址，没看见
    aad=find(ntcontratemp(2,:)==2); %没看见
    uc=ntcontratemp(1,uad);
    ac=ntcontratemp(1,aad);
   [h,p]=ttest2(ac,uc);
   ucT=[ucT uc];
   acT=[acT ac];
   pt(1,j)=p;
end

figure
if i_sub==2        % 第二个被试wrh数据太好，分组太少，单独处理
edges=2.2:0.39:5.2;
% edges=3:0.39*2:23;
h1 = histogram(acT./255*100,edges,'Normalization','probability');
% h1 = histogram(acT./255*100,'Normalization','probability');
hold on
h2 = histogram(ucT./255*100,edges,'Normalization','probability');
else
h1 = histogram(acT./255*100,'Normalization','probability'); 
hold on
h2 = histogram(ucT./255*100,'Normalization','probability');
end
% h2 = histogram(ucT./255*100,'Normalization','probability');
a=gcf;
temp1=min(h1.Values,h2.Values);
OverlapPercent=sum(temp1).*100;
legend('Aware','Unaware')
xlabel('Stimulus Contrast (%)')
ylabel('Probability ')
[~,p1,stats]=kstest2(acT,ucT);
[~,p2,stats]=ttest2(acT,ucT);
% text(22,80,{'Mean of Aware / Unaware',...
%     strcat(num2str(mean(acT)),'/',num2str(mean(ucT))),...
%     strcat('p_distri=',num2str(p1))});
SEM=[];
SEM(1)=std(acT./255*100)./sqrt(numel(acT)-1);
SEM(2)=std(ucT./255*100)./sqrt(numel(ucT)-1);
figure
stairs([h1.BinEdges(1) h1.BinEdges],[0 h1.Values 0],'LineWidth',2,'Color','r')
hold on
stairs([h2.BinEdges(1) h2.BinEdges],[0 h2.Values 0],'LineWidth',2,'Color','b')
box off
text('string',sprintf('p=%.4f',p1),'Units','normalized','position',[0.85,0.85],...
    'HorizontalAlignment','center','FontSize',20);
% text( 'string',"(a) UB-OR", 'Units','normalized','position',[0.75,0.95],...
% 'FontSize',14,'FontWeight','Bold','FontName','Times New Roman');  
% text(h1.BinEdges(end),0.5*max(h1.Values),{'Mean of Aware / Unaware',...
%     strcat(num2str(mean(acT./255*100)),'/',num2str(mean(ucT./255*100))),...
%     strcat(['p_d=',num2str(p1) '  p_m=',num2str(p2)])},...
%     'HorizontalAlignment','center');
% legend('Aware （near-threshold）','Unaware (near-threshold)')
% legend box off
legend off
title(['P',num2str(i_sub)])
xlabel('Stimulus Contrast (%)')
ylabel('Probability ')
ax=gca;
ax.FontSize=15;
ax.LineWidth=1.5;
% [p h]=kstest2(acT,ucT)
close(a)

% [x,fi]=ksdensity();
saveas(gcf,[outputpath,'ContrastAU'],'tif')
saveas(gcf,[outputpath,'ContrastAU'],'fig')
%%
% lucT=[];
% for j=1:length(ContraSession)
%     contradrtemp=find(ContraSession{3,j}<0.25);
%     contratemp=ContraSession{2,j}( contradrtemp);
%     contratemp(contratemp==0)=[];
%     contratemp=[0 contratemp'];
%     ntcontratemp=ContraSession{1,j}(:,ismember(ContraSession{1,j}(1,:),contratemp));
%     luad=find(ntcontratemp(2,:)==1); %没看见
%     luc=ntcontratemp(1,luad);
%     
%    lucT=[lucT luc];
%  
% end
% h1 = histogram(lucT,edges);
% hold on
% h2 = histogram(ucT,edges);
% legend('LU','NU')
% [h,p]=ttest2(lucT,ucT);
% text(22,160,{'Mean of LU / NU',...
%     strcat(num2str(mean(lucT)),'/',num2str(mean(ucT))),...
%     strcat('p=',num2str(p))});

end
end